#!/usr/bin/env python3
import json
import sys
from pathlib import Path


def strip_figma_fields(value):
    if isinstance(value, dict):
        cleaned = {}
        for key, child in value.items():
            if key == "$extensions" or key.startswith("com.figma"):
                continue
            cleaned[key] = strip_figma_fields(child)
        return cleaned
    if isinstance(value, list):
        return [strip_figma_fields(item) for item in value]
    return value


def main():
    if len(sys.argv) != 3:
        print("Usage: strip_figma_tokens.py <input.json> <output.json>")
        return 1

    input_path = Path(sys.argv[1])
    output_path = Path(sys.argv[2])

    data = json.loads(input_path.read_text(encoding="utf-8"))
    cleaned = strip_figma_fields(data)
    output_path.write_text(json.dumps(cleaned, ensure_ascii=True, indent=2) + "\n", encoding="utf-8")
    return 0


if __name__ == "__main__":
    raise SystemExit(main())
